﻿# 3D都市モデル（Project PLATEAU）杉戸町（2023年度）

## 作成年月日
2024年3月29日

## 3D都市モデルとは
3D都市モデルとは、都市空間に存在する建物や街路といったオブジェクトに名称や用途、建設年といった都市活動情報を付与することで、都市空間そのものを再現する3D都市空間情報プラットフォームです。 様々な都市活動データが3D都市モデルに統合され、フィジカル空間とサイバー空間の高度な融合が実現します。これにより、都市計画立案の高度化や、都市活動のシミュレーション、分析等を行うことが可能となります。  

## 内容
本データセットは、埼玉県北葛飾郡杉戸町（市域30.03km2）の3D都市モデルです。CityGML形式のデータで、次のモデルが格納されています。

+ 建築物モデル
	+ LOD1: 30.03㎞2 25,693棟（杉戸町内全域）
	+ LOD2.0: 0.08㎞2 290棟（杉戸町役場、すぎとピア、高野台小学校、杉戸第三小学校、泉小学校、杉戸町東口通り線周辺）
+ 交通（道路）モデル（LOD1：30.03km2）
	+ LOD1: 30.03㎞2（杉戸町内全域）
+ 土地利用モデルLOD1（30.03km2）
+ 災害リスク（浸水）モデルLOD1
	+ 洪水浸水想定区域（5区域）
		+利根川水系利根川洪水想定区域図（国管理）
		+利根川水系江戸川洪水想定区域図（国管理）
		+荒川水系荒川洪水想定区域図（国管理）
		+利根川水系大落古利根川洪水想定区域図（都道府県管理）
		+利根川水系中川流域水害リスク情報図（都道府県管理）
+ 都市計画決定情報モデル
	* 都市計画区域
	* 区域区分
	* 用途地域
	* 防火地域又は準防火地域
	* 土地区画整理促進区域
	* 交通施設
	* 公共空地
	* 処理施設
	* 土地区画整理事業
	* 地区計画
+ 地形モデルLOD1（30.03km2）

各モデルの整備範囲は、[索引図](11464_indexmap_op.pdf)を参照してください。  
また、整備対象とした属性等、詳細な仕様は、[拡張製品仕様書](specification/11464_2023_specification_op.pdf)を参照してください。  

## 準拠する標準製品仕様書の版
3D都市モデル標準製品仕様書 第3.3版

## 品質
+ データセット全体の位置正確度
	+ 地図情報レベル2500

その他の詳細な品質は、[メタデータ](/metadata/udx_11464_2023_op.xml)でご確認いただけます。  
なお、メタデータの閲覧には、国土地理院が公開する[公共測量用メタデータエディタ](https://psgsv2.gsi.go.jp/koukyou/public/seihinsiyou/meta-editor.html)が便利です。

## 原典資料
3D都市モデルは、自治体が保有するデータやオープンデータを組み合わせて作成されています。
作成に使用した原典資料やその原典資料が使われたエリアは[原典資料リスト](metadata/udx_11464_2023_resource_op.csv)でご確認いただけます。

## 利用に関する留意事項
本データセットは[PLATEAU Site Policy 「３．著作権について」](https://www.mlit.go.jp/plateau/site-policy/)で定められた以下のライセンスを採用します。
+ 政府標準利用規約（第2.0版）
+ [クリエイティブ・コモンズ・ライセンスの表示4.0国際](https://creativecommons.org/licenses/by/4.0/legalcode.ja)
+ ODC BY（https://opendatacommons.org/licenses/by/1-0/）
+ ODbL（https://opendatacommons.org/licenses/odbl/）  

利用者は、いずれかのライセンスを選択し、商用利用も含め、無償で自由にご利用いただけます。  
原典資料の位置の正しさの違いや、作成された時期の違いにより、現状を正確に反映していない場合があることにご注意ください。